<?php

    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "xpanel";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name' => 'xpanel',
        'use_cdn' => FALSE,
        'display_name' => 'xPanel - UrduPaper',
        'display_version' => FALSE,
        'page_slug' => 'xpanel',
        'page_title' => 'xPanel Theme Settings',
        'update_notice' => FALSE,
        'intro_text' => '<p>You can customize your theme with different options with this panel</p>’',
        'footer_text' => '<p>Powered by <a href="http://www.stylothemes.com">StyloThemes</a></p>',
        'admin_bar' => TRUE,
        'menu_type' => 'submenu',
        'menu_title' => 'Theme Settings',
        'allow_sub_menu' => TRUE,
        'page_parent' => 'themes.php',
        'page_parent_post_type' => 'your_post_type',
        'customizer' => TRUE,
        'default_show' => TRUE,
        'default_mark' => '*',
        'google_api_key' => 'AIzaSyAZncm6O4E0LFyFh3Fv0MUDkJMSbJJkLIk',
        'class' => 'xpanel',
        'hints' => array(
            'icon' => 'el el-comment',
            'icon_position' => 'right',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'light',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
                    'duration' => '500',
                    'event' => 'mouseover',
                ),
                'hide' => array(
                    'duration' => '500',
                    'event' => 'mouseleave unfocus',
                ),
            ),
        ),
        'output' => TRUE,
        'output_tag' => TRUE,
        'settings_api' => TRUE,
        'cdn_check_time' => '1440',
        'compiler' => TRUE,
        'page_permissions' => 'manage_options',
        'save_defaults' => TRUE,
        'show_import_export' => TRUE,
        'database' => 'options',
        'transient_time' => '3600',
        'network_sites' => TRUE,
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/stylotheme',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://twitter.com/StyloThemes',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://www.linkedin.com/company/stylotheme',
        'title' => 'Find us on LinkedIn',
        'icon'  => 'el el-linkedin'
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Need Support ?', 'admin_folder' ),
            'content' => __( '<h3>Having trouble setting up the theme ? Go ahead and submit a support ticket via <a href="http://stylothemes.com/shop/support" target="_blank">http://stylothemes.com/shop/support</a></h3>', 'admin_folder' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'More Themes', 'admin_folder' ),
            'content' => __( '<p>Browse collection of our more themes <a href="http://stylothemes.com/shop/support" target="_blank">http://stylothemes.com/shop</a></p>', 'admin_folder' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p><a href="http://stylothemes.com/shop" target="_blank"><img src="http://stylothemes.com/shop/wp-content/themes/styloshop/images/logo-footer.png" width="150" height="80"></a></p>', 'admin_folder' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    Redux::setSection( $opt_name, array(
        'title' => __( 'General Settings', 'xpanel-framework' ),
        'id'    => 'general',
        'desc'  => __( 'General Theme Settings.', 'xpanel-framework' ),
        'icon'  => 'el el-home'
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Logo & Favicon', 'xpanel-framework' ),
        'desc'       => __( 'Upload Your Website Logo & Favicon', 'xpanel-framework' ),
        'id'         => 'logo-favicon',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'logo',
                'type'     => 'media', 
                'url'      => true,
                'title'    => __('Logo URL', 'xpanel-framework'),
                'desc'     => __('Upload Your Website Logo.', 'xpanel-framework'),
                'subtitle' => __('Select Valid Image File ie: .png, .jpg, .gif', 'xpanel-framework'),
                'default'  => array(
                    'url'=>''.get_template_directory_uri().'/images/logo.png'
                ),
            ),

            array(
                'id'       => 'favicon',
                'type'     => 'media', 
                'url'      => true,
                'title'    => __('Favicon URL', 'xpanel-framework'),
                'desc'     => __('Upload Favicon Image for your website.', 'xpanel-framework'),
                'subtitle' => __('Select Valid Favicon File ie: .ico, .png', 'xpanel-framework'),
                'default'  => array(
                    'url'=>''.get_template_directory_uri().'/favicon.png'
                ),
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Layout Settings', 'xpanel-framework' ),
        'desc'       => __( 'Manage your website Layout', 'xpanel-framework' ),
        'id'         => 'layout-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'site-colors',
                'type'     => 'color',
                'title'    => __('Color Scheme', 'xpanel-framework'), 
                'subtitle' => __('Slecet Color Sceheme for your Website', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'default'  => '#f4ac04',
                'validate' => 'color',
            ),
            array(
                'id'       => 'totop',
                'type'     => 'checkbox',
                'title'    => __('Enable Back To Top?', 'xpanel-framework'), 
                'subtitle' => __('Enable or Disable Back To Top Button at bottom of your website', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'default'  => '1'// 1 = on | 0 = off
            ),
            
        )
    ) );
    //End of Layout Settings 
    Redux::setSection( $opt_name, array(
        'title'      => __( 'Body Backgrounds', 'xpanel-framework' ),
        'desc'       => __( 'Manage Background colors and images for main website body', 'xpanel-framework' ),
        'id'         => 'background-settings',
        'subsection' => true,
        'output'     => array('body'),
        'fields'     => array(
            
            array(
                'id'       => 'body-background',
                'type'     => 'background',
                'title'    => __('Body Background', 'xpanel-framework'),
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Body background with image, color, etc.', 'xpanel-framework'),
                'default'  => array(
                    'background-color' => '#f0f0f0',
                    'background-image' => ''.get_template_directory_uri('/').'/images/bg.png'
                ),
                'output'   => 'body'
            )
        )
    ) );
    //End of Body Backgrounds Settings
    
    
    Redux::setSection( $opt_name, array(
        'title'      => __( 'Footer Settings', 'xpanel-framework' ),
        'desc'       => __( 'Manage Footer copyright text', 'xpanel-framework' ),
        'id'         => 'footer-text-settings',
        'subsection' => true,
        'output'     => '',
        'fields'     => array(
            
            array(
                'id'=>'footer-copyright',
                'type' => 'textarea',
                'title' => __('Footer Copyright', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc' => __('Enter your website copyright text for footer. some HTML is allowed such as, <p>, <a>, <br>, <em>, <strong>', 'xpanel-framework'),
                'validate' => 'html_custom',
                'default' => 'Copyright © 2015, UrduPress all rights reserved. Theme Designed by <a href="http://www.stylothemes.com">StyloThemes</a>',
                'allowed_html' => array(
                    'a' => array(
                        'href' => array(),
                        'title' => array()
                    ),
                    'p' => array(
                        'class' => array(),
                        'id'    => array(),
                        'style' => array(),
                    ),
                    'br' => array(),
                    'em' => array(),
                    'strong' => array()
                )
            ),
            
        )
    ) );
    //End of Header Backgrounds Settings

    Redux::setSection( $opt_name, array(
        'title' => __( 'Header', 'xpanel-framework' ),
        'id'    => 'header-settings',
        'desc'  => __( 'Customize your webite header.', 'xpanel-framework' ),
        'icon'  => 'el el-cog'
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Navigation', 'xpanel-framework' ),
        'desc'       => __( 'Main Navigation Settings', 'xpanel-framework' ),
        'id'         => 'nav-settings',
        'subsection' => true,
        'output'     => "",
        'fields'     => array(
            array(
                'id'       => 'stickynav',
                'type'     => 'checkbox',
                'title'    => __('Enable Sticky Nav', 'xpanel-framework'), 
                'subtitle' => __('Make your top navigation bar stick to top while scroll down', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'default'  => '0'// 1 = on | 0 = off
            ),
            array(
                'id'       => 'nav-colors',
                'type'     => 'color',
                'title'    => __('Color Scheme', 'xpanel-framework'), 
                'subtitle' => __('Slecet Color Sceheme for Main Menu', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'default'  => '#f4ac04',
                'validate' => 'color',
            ),
        )
    ) );
    //End of Navigation Settings

    Redux::setSection( $opt_name, array(
        'title'      => __( 'News Ticker', 'xpanel-framework' ),
        'desc'       => __( 'Manage Top Scrollig News Bar', 'xpanel-framework' ),
        'id'         => 'news-ticker-settings',
        'subsection' => true,
        'output'     => "",
        'fields'     => array(
            
            array(
                'id'       => 'show-news-ticker',
                'type'     => 'switch', 
                'title'    => __('Enable/Disable News Ticker', 'xpanel-framework'),
                'desc'     => __('You can turn ON or OFF header News Ticker here.', 'xpanel-framework'),
                'default'  => true,
            ), 
            array(
                'id'       => 'news-ticker-cat',
                'type'     => 'select',
                'title'    => __('Select Category', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Choose which category posts will be shown in News ticker. Leave empty fo all categories', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'news-ticker-limit',
                'type'     => 'select',
                'title'    => __('Limit Posts', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select how many posts you want to show in News Ticker', 'xpanel-framework'),
                'options'  => array(
                        '5' =>  '5',
                        '6' =>  '5',
                        '7' =>  '7',
                        '8' =>  '8',
                        '9' =>  '9',
                        '10' =>  '10'
                    ),
                'default'  => '5',
            ),
            array(
                'id'       => 'ticker-label',
                'type'     => 'text',
                'title'    => __('Ticker Label', 'redux-framework-demo'),
                'subtitle' => __(''),
                'desc'     => __('You can change your ticker label here.', 'redux-framework-demo'),
                'default'  => ' اہم خبریں'
            )
            
        )
    ) );
    //End of News Ticker Settings

    //End of Header Settings
    Redux::setSection( $opt_name, array(
        'title' => __( 'Homepage', 'xpanel-framework' ),
        'id'    => 'homepage',
        'desc'  => __( 'Manage Homepage blocks and content areas.', 'xpanel-framework' ),
        'icon'  => 'el el-cogs'
    ) );
    Redux::setSection( $opt_name, array(
        'title'      => __( 'Block Settings', 'xpanel-framework' ),
        'desc'       => __( 'Homepage Post Block Settings', 'xpanel-framework' ),
        'id'         => 'homepage-block-settings',
        'subsection' => true,
        'fields'     => array(
            
            array(
                'id'       => 'show-classic',
                'type'     => 'switch', 
                'title'    => __('Enable/Disable Classic Block', 'xpanel-framework'),
                'desc'     => __('You can turn ON or OFF your homepage first posts block here.', 'xpanel-framework'),
                'default'  => true,
            ), 
            array(
                'id'       => 'show-columns',
                'type'     => 'switch', 
                'title'    => __('Enable/Disable Columns Block', 'xpanel-framework'),
                'desc'     => __('You can turn ON or OFF your homepage columns block here.', 'xpanel-framework'),
                'default'  => true,
            ),
            array(
                'id'       => 'homepage-grids-count',
                'type'     => 'select',
                'title'    => __('Grid Blocks Limit', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select how many Grid Post Blocks you want to dispaly on Homepage', 'xpanel-framework'),
                'options'  => array(
                           '3' => '3',
                           '6' => '6',
                           '9' => '9'
                ),
                'default'  => '6',
            ),
        )
    ) ); // End Of Block Settings

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Post Blocks Limit', 'xpanel-framework' ),
        'desc'       => __( 'Select how many Post Blocks you want to display on Homepage', 'xpanel-framework' ),
        'id'         => 'homepage-blocks',
        'subsection' => true,
        'fields'     => array(

            array(
                'id'       => 'homepage-grid-count',
                'type'     => 'select',
                'title'    => __('Total Number of Grid Blocks', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select how many post Grid Blocks you want to dispaly on Homepage', 'xpanel-framework'),
                'options'  => array(
                           '3' => '3',
                           '6' => '6',
                           '9' => '9'
                ),
                'default'  => '6',
            ),
            array(
                'id'       => 'homepage-block1-count',
                'type'     => 'select',
                'title'    => __('Classic Block Posts Limit', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select how many post you want to dispaly in Posts Block 1', 'xpanel-framework'),
                'options'  => array(
                           '4' => '4',
                           '5' => '5',
                           '6' => '6',
                           '7' => '7',
                           '8' => '8',
                           '9' => '9',
                           '10' => '10',
                           '15' => '15',
                           '20' => '20',
                           '25' => '25',
                           '30' => '30'
                ),
                'default'  => '7',
            ),
            array(
                'id'       => 'homepage-block2-count',
                'type'     => 'select',
                'title'    => __('Columns Block Posts Limit', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select how many post you want to dispaly in Posts Block 2', 'xpanel-framework'),
                'options'  => array(
                           '4' => '4',
                           '5' => '5',
                           '6' => '6',
                           '7' => '7',
                           '8' => '8',
                           '9' => '9',
                           '10' => '10',
                           '15' => '15',
                           '20' => '20',
                           '25' => '25',
                           '30' => '30'
                ),
                'default'  => '8',
            ),
            array(
                'id'       => 'homepage-grid-count',
                'type'     => 'select',
                'title'    => __('Grid Block Posts Limit', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select how many post you want to dispaly in Posts Grid Block 1', 'xpanel-framework'),
                'options'  => array(
                           '4' => '4',
                           '5' => '5',
                           '6' => '6',
                           '7' => '7',
                           '8' => '8',
                           '9' => '9',
                           '10' => '10'
                ),
                'default'  => '6',
            ),
        )
    ) ); // Post Blocks 

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Post Block Categories', 'xpanel-framework' ),
        'desc'       => __( 'Select categories for Homepage Post Blocks', 'xpanel-framework' ),
        'id'         => 'homepage-blocks-cats',
        'subsection' => true,
        'fields'     => array(

            array(
                'id'       => 'homepage-block-1',
                'type'     => 'select',
                'title'    => __('Block 1', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-block-2',
                'type'     => 'select',
                'title'    => __('Block 2', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Block 2 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-grid-1',
                'type'     => 'select',
                'title'    => __('Grid 1', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Grid Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-grid-2',
                'type'     => 'select',
                'title'    => __('Grid 2', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Grid Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-grid-3',
                'type'     => 'select',
                'title'    => __('Grid 3', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Grid Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-grid-4',
                'type'     => 'select',
                'title'    => __('Grid 4', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Grid Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-grid-5',
                'type'     => 'select',
                'title'    => __('Grid 5', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Grid Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-grid-6',
                'type'     => 'select',
                'title'    => __('Grid 6', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Grid Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-grid-7',
                'type'     => 'select',
                'title'    => __('Grid 7', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Grid Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-grid-8',
                'type'     => 'select',
                'title'    => __('Grid 8', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Grid Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'homepage-grid-9',
                'type'     => 'select',
                'title'    => __('Grid 9', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Grid Block 1 Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            )
        )
    ) ); // Post Block Categories

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Grid Block Icons', 'xpanel-framework' ),
        'desc'       => __( 'Enter Icon Classes for Grid Blocks. We used font awesome icons, so all you need to do is provide your desired icon class name in each box. ie: fa-star. You can check icon classes over here: <a href="http://fontawesome.io/icons/">http://fontawesome.io/icons/</a>', 'xpanel-framework' ),
        'id'         => 'homepage-grid-blocks-icons',
        'subsection' => true,
        'fields'     => array(

            array(
                'id'       => 'homepage-grid-icon-1',
                'type'     => 'text',
                'title'    => __('Grid 1 Icon', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Enter Icon class for Grid Block 1. eg: fa-pencil', 'xpanel-framework'),
                'default'  => 'fa-newspaper-o',
            ),
            array(
                'id'       => 'homepage-grid-icon-2',
                'type'     => 'text',
                'title'    => __('Grid 2 Icon', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Enter Icon class for Grid Block 2. eg: fa-tree', 'xpanel-framework'),
                'default'  => 'fa-newspaper-o',
            ),
            array(
                'id'       => 'homepage-grid-icon-3',
                'type'     => 'text',
                'title'    => __('Grid 3 Icon', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Enter Icon class for Grid Block 3. eg: fa-facebook', 'xpanel-framework'),
                'default'  => 'fa-newspaper-o',
            ),
            array(
                'id'       => 'homepage-grid-icon-4',
                'type'     => 'text',
                'title'    => __('Grid 4 Icon', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Enter Icon class for Grid Block 4. eg: fa-star', 'xpanel-framework'),
                'default'  => 'fa-newspaper-o',
            ),
            array(
                'id'       => 'homepage-grid-icon-5',
                'type'     => 'text',
                'title'    => __('Grid 5 Icon', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Enter Icon class for Grid Block 5. eg: fa-cubes', 'xpanel-framework'),
                'default'  => 'fa-newspaper-o',
            ),
            array(
                'id'       => 'homepage-grid-icon-6',
                'type'     => 'text',
                'title'    => __('Grid 6 Icon', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Enter Icon class for Grid Block 6. eg: fa-cogs', 'xpanel-framework'),
                'default'  => 'fa-newspaper-o',
            ),
            array(
                'id'       => 'homepage-grid-icon-7',
                'type'     => 'text',
                'title'    => __('Grid 7 Icon', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Enter Icon class for Grid Block 7. eg: fa-music', 'xpanel-framework'),
                'default'  => 'fa-newspaper-o',
            ),
            array(
                'id'       => 'homepage-grid-icon-8',
                'type'     => 'text',
                'title'    => __('Grid 8 Icon', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Enter Icon class for Grid Block 8. eg: fa-random', 'xpanel-framework'),
                'default'  => 'fa-newspaper-o',
            ),
            array(
                'id'       => 'homepage-grid-icon-9',
                'type'     => 'text',
                'title'    => __('Grid 9 Icon', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Enter Icon class for Grid Block 9. eg: fa-tag', 'xpanel-framework'),
                'default'  => 'fa-newspaper-o',
            )
        )
    ) ); // Grid Block Icons

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Carousel Slider', 'xpanel-framework' ),
        'desc'       => __( 'Homepage Carousel Slider Settings', 'xpanel-framework' ),
        'id'         => 'homepage-carousel',
        'subsection' => true,
        'fields'     => array(
            
            array(
                'id'       => 'show-carousel',
                'type'     => 'switch', 
                'title'    => __('Enable/Disable Carousel', 'xpanel-framework'),
                'desc'     => __('You can turn ON or OFF your homepage posts carousel here.', 'xpanel-framework'),
                'default'  => true,
            ), 
            array(
                'id'       => 'show-overlay',
                'type'     => 'switch', 
                'title'    => __('Show/Hide Overlay Icon', 'xpanel-framework'),
                'desc'     => __('You can turn ON or OFF the overlay icon for carousel posts.', 'xpanel-framework'),
                'default'  => true,
            ),
            array(
                'id'       => 'carousel-cat',
                'type'     => 'select',
                'title'    => __('Carousel Category', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select Category For Carousel Slider Posts on Homepage', 'xpanel-framework'),
                'data'     => 'categories',
                'default'  => '0',
            ),
            array(
                'id'       => 'carousel-count',
                'type'     => 'select',
                'title'    => __('Carousel Posts Limit', 'xpanel-framework'), 
                'subtitle' => __('', 'xpanel-framework'),
                'desc'     => __('Select how many post you want to dispaly in Carousel Slider', 'xpanel-framework'),
                'options'  => array(
                           '5' => '5',
                           '10' => '10',
                           '15' => '15',
                           '20' => '20',
                           '25' => '25'
                ),
                'default'  => '10',
            ),
        )
    ) ); // Carousel Slider

    
    //End of Homepage Setings

    Redux::setSection( $opt_name, array(
        'title' => __( 'Post Settings', 'xpanel-framework' ),
        'id'    => 'post-settings',
        'desc'  => __( 'Manage your posts layout and settings.', 'xpanel-framework' ),
        'icon'  => 'el el-tasks'
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Post Meta', 'xpanel-framework' ),
        'desc'       => __( 'Post Meta Information Settings', 'xpanel-framework' ),
        'id'         => 'post-meta-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'show-author',
                'type'     => 'switch', 
                'title'    => __('Post Author', 'xpanel-framework'),
                'desc'     => __('Show Post Author Under Post Title?', 'xpanel-framework'),
                'default'  => true,
            ),
            array(
                'id'       => 'show-views',
                'type'     => 'switch', 
                'title'    => __('Post Views', 'xpanel-framework'),
                'desc'     => __('Show or Hide Post Views', 'xpanel-framework'),
                'default'  => true,
            ),
            array(
                'id'       => 'show-comment-count',
                'type'     => 'switch', 
                'title'    => __('Post Comments', 'xpanel-framework'),
                'desc'     => __('Show Post Comments Count Under Post Title?', 'xpanel-framework'),
                'default'  => true,
            ),
            array(
                'id'       => 'show-posted-date',
                'type'     => 'switch', 
                'title'    => __('Posted Date', 'xpanel-framework'),
                'desc'     => __('Show Post Publish Date in Single Post View?', 'xpanel-framework'),
                'default'  => true,
            ),

        )
    ) );//Post Meta

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Post Layout', 'xpanel-framework' ),
        'desc'       => __( 'Customize your single post view layout', 'xpanel-framework' ),
        'id'         => 'post-layout-settings',
        'subsection' => true,
        'fields'     => array(
            /*array(
                'id'       => 'post-ad-code',
                'type'     => 'textarea', 
                'title'    => __('Inside Post AD Code', 'xpanel-framework'),
                'desc'     => __('Enter your inside post ad code', 'xpanel-framework'),
                'default'  => true,
            ),*/
            array(
                'id'       => 'show-ratings',
                'type'     => 'switch', 
                'title'    => __('Post Ratings', 'xpanel-framework'),
                'desc'     => __('Show/Hide Post Ratings Box Below Post Content', 'xpanel-framework'),
                'default'  => true,
            ),
            array(
                'id'       => 'show-zoom',
                'type'     => 'switch', 
                'title'    => __('ZoomIn/ZoomOut', 'xpanel-framework'),
                'desc'     => __('Enable or Disable Font Size Increase/Decrease Option.', 'xpanel-framework'),
                'default'  => true,
            ),
            array(
                'id'       => 'show-related-posts',
                'type'     => 'switch', 
                'title'    => __('Related Posts', 'xpanel-framework'),
                'desc'     => __('Enable or Disable Related posts block after post content.', 'xpanel-framework'),
                'default'  => true,
            ),

        )
    ) );//Post Layout

    //End of Post Settings
    Redux::setSection( $opt_name, array(
        'title' => __( 'Typography', 'xpanel-framework' ),
        'id'    => 'typography',
        'desc'  => __( 'Manage Font Family, Style, Size & Color.', 'xpanel-framework' ),
        'icon'  => 'el el-font'
    ) );
    Redux::setSection( $opt_name, array(
        'title'      => __( 'Headings', 'xpanel-framework' ),
        'desc'       => __( 'Select Font Styling for Headings', 'xpanel-framework' ),
        'id'         => 'font-headings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'          => 'font-h1',
                'type'        => 'typography', 
                'title'       => __('H1', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                              'Sameer Regular' => 'Sameer Regular',
                              'AhmadLT Regular' => 'AhmadLT Regular',
                              'AkramUnicode Regular' => 'Akram Unicode',
                              'Alkatib Regular' => 'Alkatib Regular',
                              'AlQalam Regular' => 'AlQalam Regular',
                              'AlQalam Telenor' => 'AlQalam Telenor',
                              'Batool Unicode Regular' => 'Batool Unicode',
                              'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                              'Nastaleeq Like' => 'Nastaleeq Like',
                              'Pak Lotus' => 'Pak Lotus',
                              'Sameer Zikran' => 'Sameer Zikran',
                              'Microsoft Uighur' => 'Microsoft Uighur',
                              'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ),
                'font-backup' => true,
                'output'      => array('h1'),
                'units'       =>'px',
                'subtitle'    => __('Heading 1 (H1 tag)', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#222', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size'   => '38px',
                    'line-height'   => '70px'
                ),
            ),
            array(
                'id'          => 'font-h2',
                'type'        => 'typography', 
                'title'       => __('H2', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                              'Sameer Regular' => 'Sameer Regular',
                              'AhmadLT Regular' => 'AhmadLT Regular',
                              'AkramUnicode Regular' => 'Akram Unicode',
                              'Alkatib Regular' => 'Alkatib Regular',
                              'AlQalam Regular' => 'AlQalam Regular',
                              'AlQalam Telenor' => 'AlQalam Telenor',
                              'Batool Unicode Regular' => 'Batool Unicode',
                              'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                              'Nastaleeq Like' => 'Nastaleeq Like',
                              'Pak Lotus' => 'Pak Lotus',
                              'Sameer Zikran' => 'Sameer Zikran',
                              'Microsoft Uighur' => 'Microsoft Uighur',
                              'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ),
                'font-backup' => true,
                'output'      => array('h2'),
                'units'       =>'px',
                'subtitle'    => __('Heading 2 (H2 tag)', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#222', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size' => '34px',
                    'line-height' => '68px'
                ),
            ),
            array(
                'id'          => 'font-h3',
                'type'        => 'typography', 
                'title'       => __('H3', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                              'Sameer Regular' => 'Sameer Regular',
                              'AhmadLT Regular' => 'AhmadLT Regular',
                              'AkramUnicode Regular' => 'Akram Unicode',
                              'Alkatib Regular' => 'Alkatib Regular',
                              'AlQalam Regular' => 'AlQalam Regular',
                              'AlQalam Telenor' => 'AlQalam Telenor',
                              'Batool Unicode Regular' => 'Batool Unicode',
                              'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                              'Nastaleeq Like' => 'Nastaleeq Like',
                              'Pak Lotus' => 'Pak Lotus',
                              'Sameer Zikran' => 'Sameer Zikran',
                              'Microsoft Uighur' => 'Microsoft Uighur',
                              'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ),
                'font-backup' => true,
                'output'      => array('h3'),
                'units'       =>'px',
                'subtitle'    => __('Heading 3 (H3 tag)', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#222', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size'   => '30px',
                    'line-height' => '60px'
                ),
            ),
            array(
                'id'          => 'font-h4',
                'type'        => 'typography', 
                'title'       => __('H4', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                      'Sameer Regular' => 'Sameer Regular',
                      'AhmadLT Regular' => 'AhmadLT Regular',
                      'AkramUnicode Regular' => 'Akram Unicode',
                      'Alkatib Regular' => 'Alkatib Regular',
                      'AlQalam Regular' => 'AlQalam Regular',
                      'AlQalam Telenor' => 'AlQalam Telenor',
                      'Batool Unicode Regular' => 'Batool Unicode',
                      'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                      'Nastaleeq Like' => 'Nastaleeq Like',
                      'Pak Lotus' => 'Pak Lotus',
                      'Sameer Zikran' => 'Sameer Zikran',
                      'Microsoft Uighur' => 'Microsoft Uighur',
                      'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ),
                'font-backup' => true,
                'output'      => array('h4'),
                'units'       =>'px',
                'subtitle'    => __('Heading 4 (H4 tag)', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#222', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size'   => '26px',
                    'line-height' => '48px'
                ),
            ),
            array(
                'id'          => 'font-h5',
                'type'        => 'typography', 
                'title'       => __('H5', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                      'Sameer Regular' => 'Sameer Regular',
                      'AhmadLT Regular' => 'AhmadLT Regular',
                      'AkramUnicode Regular' => 'Akram Unicode',
                      'Alkatib Regular' => 'Alkatib Regular',
                      'AlQalam Regular' => 'AlQalam Regular',
                      'AlQalam Telenor' => 'AlQalam Telenor',
                      'Batool Unicode Regular' => 'Batool Unicode',
                      'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                      'Nastaleeq Like' => 'Nastaleeq Like',
                      'Pak Lotus' => 'Pak Lotus',
                      'Sameer Zikran' => 'Sameer Zikran',
                      'Microsoft Uighur' => 'Microsoft Uighur',
                      'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ),
                'font-backup' => true,
                'output'      => array('h5'),
                'units'       =>'px',
                'subtitle'    => __('Heading 5 (H5 tag)', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#222', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size'   => '18px',
                    'line-height' => '36px'
                ),
            ),
            array(
                'id'          => 'font-h6',
                'type'        => 'typography', 
                'title'       => __('H6', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                      'Sameer Regular' => 'Sameer Regular',
                      'AhmadLT Regular' => 'AhmadLT Regular',
                      'AkramUnicode Regular' => 'Akram Unicode',
                      'Alkatib Regular' => 'Alkatib Regular',
                      'AlQalam Regular' => 'AlQalam Regular',
                      'AlQalam Telenor' => 'AlQalam Telenor',
                      'Batool Unicode Regular' => 'Batool Unicode',
                      'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                      'Nastaleeq Like' => 'Nastaleeq Like',
                      'Pak Lotus' => 'Pak Lotus',
                      'Sameer Zikran' => 'Sameer Zikran',
                      'Microsoft Uighur' => 'Microsoft Uighur',
                      'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ), 
                'font-backup' => true,
                'output'      => array('h6'),
                'units'       => 'px',
                'subtitle'    => __('Heading 6 (H6 tag)', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#222', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size'   => '18px',
                    'line-height' => '36px'
                ),
            ),
            
        )
    ) );
    //End of Headings
    Redux::setSection( $opt_name, array(
        'title'      => __( 'Footer Widgets', 'xpanel-framework' ),
        'desc'       => __( 'Select Font Styling for Footer Widgets', 'xpanel-framework' ),
        'id'         => 'font-footer',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'          => 'font-footer-widgets',
                'type'        => 'typography', 
                'title'       => __('Footer Widget', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                      'Sameer Regular' => 'Sameer Regular',
                      'AhmadLT Regular' => 'AhmadLT Regular',
                      'AkramUnicode Regular' => 'Akram Unicode',
                      'Alkatib Regular' => 'Alkatib Regular',
                      'AlQalam Regular' => 'AlQalam Regular',
                      'AlQalam Telenor' => 'AlQalam Telenor',
                      'Batool Unicode Regular' => 'Batool Unicode',
                      'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                      'Nastaleeq Like' => 'Nastaleeq Like',
                      'Pak Lotus' => 'Pak Lotus',
                      'Sameer Zikran' => 'Sameer Zikran',
                      'Microsoft Uighur' => 'Microsoft Uighur',
                      'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ), 
                'font-backup' => true,
                'output'      => array('.footer-widget'),
                'units'       =>'px',
                'subtitle'    => __('Main Navigation Font Settings', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#f0f0f0', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size'   => '16px',
                    'line-height' => '32px'
                ),
            ),
            
        )
    ) );
    //End of Footer Widget Font Settings
    
    Redux::setSection( $opt_name, array(
        'title'      => __( 'Paragraphs', 'xpanel-framework' ),
        'desc'       => __( 'Select Font Styling for Paragraphs', 'xpanel-framework' ),
        'id'         => 'font-paragraphs',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'          => 'font-p',
                'type'        => 'typography', 
                'title'       => __('<p>', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                      'Sameer Regular' => 'Sameer Regular',
                      'AhmadLT Regular' => 'AhmadLT Regular',
                      'AkramUnicode Regular' => 'Akram Unicode',
                      'Alkatib Regular' => 'Alkatib Regular',
                      'AlQalam Regular' => 'AlQalam Regular',
                      'AlQalam Telenor' => 'AlQalam Telenor',
                      'Batool Unicode Regular' => 'Batool Unicode',
                      'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                      'Nastaleeq Like' => 'Nastaleeq Like',
                      'Pak Lotus' => 'Pak Lotus',
                      'Sameer Zikran' => 'Sameer Zikran',
                      'Microsoft Uighur' => 'Microsoft Uighur',
                      'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ), 
                'font-backup' => true,
                'output'      => array('.entry-content p'),
                'units'       =>'px',
                'subtitle'    => __('Paragraph Font Settings', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#555', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size'   => '22px',
                    'line-height' => '44px'
                ),
            ),
            
        )
    ) );
    //End of Paragraphs
    Redux::setSection( $opt_name, array(
        'title'      => __( 'Menu', 'xpanel-framework' ),
        'desc'       => __( 'Select Font Styling for Top Menu', 'xpanel-framework' ),
        'id'         => 'font-navigation',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'          => 'font-nav',
                'type'        => 'typography', 
                'title'       => __('<p>', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                      'Sameer Regular' => 'Sameer Regular',
                      'AhmadLT Regular' => 'AhmadLT Regular',
                      'AkramUnicode Regular' => 'Akram Unicode',
                      'Alkatib Regular' => 'Alkatib Regular',
                      'AlQalam Regular' => 'AlQalam Regular',
                      'AlQalam Telenor' => 'AlQalam Telenor',
                      'Batool Unicode Regular' => 'Batool Unicode',
                      'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                      'Nastaleeq Like' => 'Nastaleeq Like',
                      'Pak Lotus' => 'Pak Lotus',
                      'Sameer Zikran' => 'Sameer Zikran',
                      'Microsoft Uighur' => 'Microsoft Uighur',
                      'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ), 
                'font-backup' => true,
                'output'      => '.main-menu',
                'units'       =>'px',
                'subtitle'    => __('Main Navigation Font Settings', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#f0f0f0', 
                    'font-style'  => '400', 
                    'font-family' => 'Alkatib Regular', 
                    'google'      => false,
                    'font-size'   => '20px',
                    'line-height' => '30px'
                ),
            ),
            
        )
    ) );
    //End of Navigation
    Redux::setSection( $opt_name, array(
        'title'      => __( 'News Ticker', 'xpanel-framework' ),
        'desc'       => __( 'Select Font Styling for News Ticker', 'xpanel-framework' ),
        'id'         => 'font-ticker',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'          => 'font-ticker-label',
                'type'        => 'typography', 
                'title'       => __('News Ticker Label', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                      'Sameer Regular' => 'Sameer Regular',
                      'AhmadLT Regular' => 'AhmadLT Regular',
                      'AkramUnicode Regular' => 'Akram Unicode',
                      'Alkatib Regular' => 'Alkatib Regular',
                      'AlQalam Regular' => 'AlQalam Regular',
                      'AlQalam Telenor' => 'AlQalam Telenor',
                      'Batool Unicode Regular' => 'Batool Unicode',
                      'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                      'Nastaleeq Like' => 'Nastaleeq Like',
                      'Pak Lotus' => 'Pak Lotus',
                      'Sameer Zikran' => 'Sameer Zikran',
                      'Microsoft Uighur' => 'Microsoft Uighur',
                      'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ), 
                'font-backup' => true,
                'output'      => array('.breaking_head'),
                'units'       =>'px',
                'subtitle'    => __('News Ticker Label Font Settings', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#222', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size'   => '20px',
                    'line-height' => '24px'
                ),
            ),
            array(
                'id'          => 'font-ticker-body',
                'type'        => 'typography', 
                'title'       => __('News Ticker Body', 'xpanel-framework'),
                'google'      => false, 
                'fonts'       => array(
                      'Sameer Regular' => 'Sameer Regular',
                      'AhmadLT Regular' => 'AhmadLT Regular',
                      'AkramUnicode Regular' => 'Akram Unicode',
                      'Alkatib Regular' => 'Alkatib Regular',
                      'AlQalam Regular' => 'AlQalam Regular',
                      'AlQalam Telenor' => 'AlQalam Telenor',
                      'Batool Unicode Regular' => 'Batool Unicode',
                      'Fajar Nastaleeq' => 'Fajar Nastaleeq',
                      'Nastaleeq Like' => 'Nastaleeq Like',
                      'Pak Lotus' => 'Pak Lotus',
                      'Sameer Zikran' => 'Sameer Zikran',
                      'Microsoft Uighur' => 'Microsoft Uighur',
                      'nafeesnastaleeq' => 'Nafees Nastaleeq',
                ), 
                'font-backup' => true,
                'output'      => array('.breaking_body'),
                'units'       =>'px',
                'subtitle'    => __('News Ticker Body Font Settings', 'xpanel-framework'),
                'default'     => array(
                    'color'       => '#222', 
                    'font-style'  => '400', 
                    'font-family' => 'nafeesnastaleeq', 
                    'google'      => false,
                    'font-size'   => '18px',
                    'line-height' => '36px'
                ),
            ),
            
        )
    ) );
    //End of News Ticker Font Settings
    Redux::setSection( $opt_name, array(
        'title' => __( 'Social Media', 'xpanel-framework' ),
        'id'    => 'social',
        'desc'  => __( 'Social Media Icons & Sharing Settings.', 'xpanel-framework' ),
        'icon'  => 'el el-share'
    ) );
    Redux::setSection( $opt_name, array(
        'title'      => __( 'URL Settings', 'xpanel-framework' ),
        'desc'       => __( 'Enter Your Social Media Profile Links. These linked icons will be displayed in footer.', 'xpanel-framework' ),
        'id'         => 'social-urls',
        'subsection' => true,

        'fields'     => array(
            array(
                'id'       => 'fb-url',
                'type'     => 'text',
                'title'    => __('Facebook URL', 'xpanel-framework'),
                'subtitle' => __('Enter your facebook page or profile URL here.', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'validate' => 'url',
                'msg'      => 'Please enter a valid URL',
                'default'  => 'http://www.facebook.com/xitclubsolutions'
            ),
            array(
                'id'       => 'twitter-url',
                'type'     => 'text',
                'title'    => __('Twitter URL', 'xpanel-framework'),
                'subtitle' => __('Enter your twitter profile URL here.', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'validate' => 'url',
                'msg'      => 'Please enter a valid URL',
                'default'  => 'http://www.twitter.com/xitclub'
            ),
            array(
                'id'       => 'gplus-url',
                'type'     => 'text',
                'title'    => __('Google+ URL', 'xpanel-framework'),
                'subtitle' => __('Enter your Google+ page or profile URL here.', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'validate' => 'url',
                'msg'      => 'Please enter a valid URL',
                'default'  => 'http://plus.google.com/+Xitclubpage'
            ),
            array(
                'id'       => 'pinterest-url',
                'type'     => 'text',
                'title'    => __('Pinterest URL', 'xpanel-framework'),
                'subtitle' => __('Enter your Pinterest profile URL here.', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'validate' => 'url',
                'msg'      => 'Please enter a valid URL',
                'default'  => 'http://www.pinterest.com/xitclub'
            ),
            array(
                'id'       => 'linkedin-url',
                'type'     => 'text',
                'title'    => __('LinkedIn URL', 'xpanel-framework'),
                'subtitle' => __('Enter your LinkedIn profile or Company URL here.', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'validate' => 'url',
                'msg'      => 'Please enter a valid URL',
                'default'  => 'http://www.linkedin.com/company/xitclub-solutions'
            ),
            array(
                'id'       => 'reddit-url',
                'type'     => 'text',
                'title'    => __('Reddit URL', 'xpanel-framework'),
                'subtitle' => __('Enter your Reddit profile or sub-reddit URL here.', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'validate' => 'url',
                'msg'      => 'Please enter a valid URL',
                'default'  => 'http://www.reddit.com/xitclub'
            ),
            array(
                'id'       => 'stumble-url',
                'type'     => 'text',
                'title'    => __('StumbleUpon URL', 'xpanel-framework'),
                'subtitle' => __('Enter your StumbleUpon profile URL here.', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'validate' => 'url',
                'msg'      => 'Please enter a valid URL',
                'default'  => 'http://www.stumbleupon.com/xitclub'
            ),
            array(
                'id'       => 'youtube-url',
                'type'     => 'text',
                'title'    => __('YouTube URL', 'xpanel-framework'),
                'subtitle' => __('Enter your YouTube Channel or profile URL here.', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'validate' => 'url',
                'msg'      => 'Please enter a valid URL',
                'default'  => 'http://www.youtube.com/user/xitclub'
            ),
        )
    ) );
    //End of Social Media URL Settings
    
    Redux::setSection( $opt_name, array(
        'title'      => __( 'Sharing Settings', 'xpanel-framework' ),
        'desc'       => __( 'Manage Sharing & Social Media Button Settings', 'xpanel-framework' ),
        'id'         => 'social-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'social-sidebar',
                'type'     => 'checkbox',
                'title'    => __('Enable Sharing Bar', 'xpanel-framework'), 
                'subtitle' => __('Enable or Disable Social Media Sharing Vertical Sidebar', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'default'  => '1'// 1 = on | 0 = off
            ),
            array(
                'id'       => 'social-postion',
                'type'     => 'select',
                'title'    => __('Select Position', 'xpanel-framework'), 
                'subtitle' => __('Slect where you want to display sidebar, Left or Right', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'options'  => array(
                    '1' => 'Right',
                    '2' => 'Left'
                ),
                'default'  => '1',
            ),
            array(
                'id'       => 'social-rounded',
                'type'     => 'checkbox',
                'title'    => __('Enable Rounded Icons?', 'xpanel-framework'), 
                'subtitle' => __('If Enabled, Icons will be in round shape. Default are Square', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'default'  => '0'// 1 = on | 0 = off
            ),
            array(
                'id'       => 'social-hover',
                'type'     => 'checkbox',
                'title'    => __('Hover Effects?', 'xpanel-framework'), 
                'subtitle' => __('Enable or Disable Beautiful Hover effect on social media icons', 'xpanel-framework'),
                'desc'     => __('', 'xpanel-framework'),
                'default'  => '1'// 1 = on | 0 = off
            ),
        )
    ) );
    /* End of Social Media Icons Settings */

    /*
     * <--- END SECTIONS
     */
