<?php
/**
 * Urdu News functions and definitions
 *
 * @package Urdu Paper
 */

if ( ! function_exists( 'upaper_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function upaper_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Urdu News, use a find and replace
	 * to change 'upaper' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'upaper', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );

	add_image_size( 'thumbnail-widget', 120, 90, array( 'center', 'center' ) );

	add_image_size( 'postblock-large', 360, 210, array( 'center', 'center' ) );

	add_image_size( 'postblock-carousel', 200, 180, array( 'center', 'center' ) );

	add_image_size( 'postblock-small', 120, 120, array( 'center', 'center' ) );

	add_image_size( 'postblock-grid', 372, 218, array( 'center', 'center' ) );

	add_image_size( 'post-head', 800, 320, array( 'center', 'center' ) );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary Menu', 'upaper' ),
		'small' => esc_html__( 'Small Header Menu', 'upaper' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'upaper_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
	//HTML5 Search Form
	add_theme_support( 'html5', array( 'search-form' ) );
}
endif; // upaper_setup
add_action( 'after_setup_theme', 'upaper_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function upaper_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'upaper_content_width', 640 );
}
add_action( 'after_setup_theme', 'upaper_content_width', 0 );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function upaper_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Home Block 1 Sidebar', 'upaper' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Home Block 2 Sidebar', 'upaper' ),
		'id'            => 'sidebar-2',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Single Post Sidebar', 'upaper' ),
		'id'            => 'sidebar-single',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'AD - Header', 'upaper' ),
		'id'            => 'header-ad',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="advert-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title hidden-lg hidden-md hidden-sm hidden-xs">',
		'after_title'   => '</h4>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'AD - Above Post Content', 'upaper' ),
		'id'            => 'above-post-ad',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="advert-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title hidden-lg hidden-md hidden-sm hidden-xs">',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'AD - Below Post Content', 'upaper' ),
		'id'            => 'beloww-post-ad',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="advert-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title hidden-lg hidden-md hidden-sm hidden-xs">',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Home AD Block 1', 'upaper' ),
		'id'            => 'ad-block1',
		'description'   => 'Homepage AD block 1, above carousel slider',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Home AD Block 2', 'upaper' ),
		'id'            => 'ad-block2',
		'description'   => 'Homepage AD block 2, after first row of Grid blocks',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Home AD Block 3', 'upaper' ),
		'id'            => 'ad-block3',
		'description'   => 'Homepage AD block 3, after 2nd row of Grid Blocks',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 1', 'upaper' ),
		'id'            => 'footer-1',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 2', 'upaper' ),
		'id'            => 'footer-2',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 3', 'upaper' ),
		'id'            => 'footer-3',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 4', 'upaper' ),
		'id'            => 'footer-4',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );

	
	
}
add_action( 'widgets_init', 'upaper_widgets_init' );


function wpdocs_custom_excerpt_length( $length ) {
    return 40;
}
add_filter( 'excerpt_length', 'wpdocs_custom_excerpt_length', 999 );

function new_excerpt_more( $more ) {
	return ' <a class="read-more" href="' . get_permalink( get_the_ID() ) . '">' . __( 'مزید پڑھیں', 'upaper' ) . '</a>';
}
add_filter( 'excerpt_more', 'new_excerpt_more' );

/**
 * Remove empty paragraphs created by wpautop()
 * @author Ryan Hamilton
 * @link https://gist.github.com/Fantikerz/5557617
 */
function remove_empty_p( $content ) {
    $content = force_balance_tags( $content );
    $content = preg_replace( '#<p>\s*+(<br\s*/*>)?\s*</p>#i', '', $content );
    $content = preg_replace( '~\s?<p>(\s|&nbsp;)+</p>\s?~', '', $content );
    return $content;
}
add_filter('the_content', 'remove_empty_p', 20, 1);


/**
 * Remove Redux Ads
 */
function removeDemoMod() { // Be sure to rename this function to something more unique
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}
add_action('init', 'removeDemoMod');

add_action( 'admin_menu', 'remove_redux_menu',12 );
function remove_redux_menu() {
    remove_submenu_page('tools.php','redux-about');
}

if ( ! function_exists( 'redux_disable_dev_mode_plugin' ) ) {
    function redux_disable_dev_mode_plugin( $redux ) {
        if ( $redux->args['opt_name'] != 'redux_demo' ) {
            $redux->args['dev_mode'] = false;
            $redux->args['forced_dev_mode_off'] = false;
        }
    }
    add_action( 'redux/construct', 'redux_disable_dev_mode_plugin' );
}


// Function to get the client ip address
function get_client_ip_server() {
    $ipaddress = '';
    if ($_SERVER['HTTP_CLIENT_IP'])
        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    else if($_SERVER['HTTP_X_FORWARDED_FOR'])
        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    else if($_SERVER['HTTP_X_FORWARDED'])
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    else if($_SERVER['HTTP_FORWARDED_FOR'])
        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    else if($_SERVER['HTTP_FORWARDED'])
        $ipaddress = $_SERVER['HTTP_FORWARDED'];
    else if($_SERVER['REMOTE_ADDR'])
        $ipaddress = $_SERVER['REMOTE_ADDR'];
    else
        $ipaddress = 'UNKNOWN';
 
    return $ipaddress;
}
//Get User Country By IP 
function ip_visitor_country($ip_address,$type)
{

    $client = $ip_address;
    $output = $type;
    $country  = "Unknown";

    if(filter_var($client, FILTER_VALIDATE_IP))
    {
        $ip = $client;
    }
    elseif(filter_var($forward, FILTER_VALIDATE_IP))
    {
        $ip = $forward;
    }
    else
    {
        $ip = $remote;
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "http://www.geoplugin.net/json.gp?ip=".$ip);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    $ip_data_in = curl_exec($ch); // string
    curl_close($ch);

    $ip_data = json_decode($ip_data_in,true);
    $ip_data = str_replace('&quot;', '"', $ip_data); // for PHP 5.2 see stackoverflow.com/questions/3110487/

    if($ip_data && $ip_data['geoplugin_countryName'] != null) {
    	if($output == 'name') {
    		$country = $ip_data['geoplugin_countryName'];
    	}
    	elseif($output == 'code') {
    		$country = $ip_data['geoplugin_countryCode'];
    	}
    	elseif($output == 'city') {
    		$country = $ip_data['geoplugin_city'];
    	}
    	else {
    		$country = $ip_data['geoplugin_countryName'];
    	}
        
    }

    return $country;
}
/**
 * Ajax Functions
 */
function add_ajax_file() {
	wp_enqueue_script('my-ajax',get_template_directory_uri() . '/js/ajax.js',array('jquery'),true);

	wp_localize_script( 'my-ajax', 'my_ajax_url', array(
		'ajax_url' => admin_url( 'admin-ajax.php' )
	));
}
add_action('wp_enqueue_scripts','add_ajax_file');
add_action( 'wp_ajax_my_ajax_function', 'my_ajax_function' );
add_action( 'wp_ajax_nopriv_my_ajax_function', 'my_ajax_function' );

add_action('init', 'myStartSession', 1);
add_action('wp_logout', 'myEndSession');
add_action('wp_login', 'myEndSession');

function myStartSession() {
    if(!session_id()) {
        @session_start();
    }
}

function myEndSession() {
    @session_destroy ();
}

function my_ajax_function() {
	$ip = $_POST['ip'];
	$id = $_POST['id'];
	$val = $_POST['val'];

	global $wpdb;
	$table_name = $wpdb->prefix . "ratings";

	$check_rating = $wpdb->get_row("SELECT * FROM $table_name WHERE user_ip = '".$ip."' AND post_id = '".$id."' ");

	if($check_rating) {
		echo "<h2 class='alert alert-danger'>"."آپ پہلے ہی اس خبر پر اپنی رائے کا اظہار کر چکے ہیں"."</h2>";
		wp_die();
	}
	else {
		$sql = $wpdb->insert(
			''.$table_name.'',
			array(
				'user_ip' => $ip,
				'post_id' => $id,
				'rating_value' => $val
			)
		);
		if($sql) {
			echo "<h2 class='alert alert-success'>"."آپکی رائے محفوظ ہو چکی ہے۔ رائے دینے کا شکریہ"."</h2>";
			wp_die(); 
		}
		else {
			echo "<h2 class='alert alert-info'>"."ہم معذرت چاہتے ہیں، آپکی رائے محفوظ نہ کی جا سکی"."</h2>";
			wp_die();
		}	
	}
	wp_die(); 
}
function ocdi_import_files() {
    return array(
        array(
            'import_file_name'             => 'Demo Import 1',
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'admin/demo/content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'admin/demo/widgets.json',
            'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'admin/demo/customizer.dat',
            'import_preview_image_url'     => trailingslashit( get_template_directory() ) . 'admin/demo/screen-image.jpg',
            'import_notice'                => __( 'After you import this demo, you will have to setup the Homepage separately via <strong>Appearance>Theme Settings</strong> OR <strong>Appearance>Customize</strong>.', 'upaper' ),
        )
    );
}
add_filter( 'pt-ocdi/import_files', 'ocdi_import_files' );

/************************************************************************
* Extended Example:
* Way to set menu, import revolution slider, and set home page.
*************************************************************************/
function ocdi_after_import( $selected_import ) {
	$top_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
    $small_menu = get_term_by( 'name', 'Small Menu', 'nav_menu' );
    if ( isset( $top_menu->term_id ) ) {
        set_theme_mod( 'nav_menu_locations', array(
                'primary' => $top_menu->term_id,
                'small' => $small_menu->term_id
            )
        );
    }
}
add_action( 'pt-ocdi/after_import', 'ocdi_after_import' );

/**
 * Post Rating
 */
require get_template_directory() . '/inc/post-rating.php';

/**
 * Post Views Counter
 */
require get_template_directory() . '/inc/views-counter.php';

/**
 * Register Scripts & Styles.
 */
require get_template_directory() . '/inc/register-scripts.php';
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/urdu-date.php';

/** Include the TGM_Plugin_Activation class. */
require_once dirname( __FILE__ ) . '/inc/class-tgm-plugin-activation.php';

/* Include Urdu Kewyboard */
include_once('inc/urdu-keyboard.php');

/* Include Menu Icons */
include_once('inc/menu-icons.php');

/* Include One Click Demo Import */
include_once('inc/one-click-demo-import.php');

/**
 * Load Custom Widgets.
 */
require get_template_directory() . '/inc/widget-catposts.php';
require get_template_directory() . '/inc/widget-featured-pots.php';
/**
 * Load Theme Admin Panel.
 */
require get_template_directory() . '/admin/admin-init.php';
