<?php
/**
 * The header for our theme.
 *
 * @package UrduPaper
 */
global $xpanel;
?><!DOCTYPE html>
<!--[if lt IE 7]><html dir="rtl" lang="ar" class="no-js lt-ie9 lt-ie8 lt-ie7"><![endif]--> <!--[if (IE 7)&!(IEMobile)]><html dir="rtl" lang="ar" class="no-js lt-ie9 lt-ie8"><![endif]--> <!--[if (IE 8)&!(IEMobile)]><html dir="rtl" lang="ar" class="no-js lt-ie9"><![endif]--> <!--[if gt IE 8]><!--> 
<html dir="rtl" lang="en-US">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php
if(is_single()) {
?>
<meta property="og:title" content="<?php the_title() ?>"/>
<meta property="og:url" content="<?php the_permalink() ?>"/>
<meta property="og:site_name" content="<?php bloginfo('name') ?>"/>
<?php 
if( has_post_thumbnail() ) {
$image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); 
?>
<meta property="og:image" content="<?php echo $image[0] ?>"/>
<?php } }?>
<?php wp_head(); ?>
<?php get_template_part( 'inc/color', 'scheme' ); ?>
<?php 
	if(isset($xpanel['preloader']) && $xpanel['preloader'] == 1) {
?>
<!-- Preloader -->
<script type="text/javascript">
	//<![CDATA[
		jQuery(window).load(function() { // makes sure the whole site is loaded
			jQuery('#loader').fadeOut(); // will first fade out the loading animation
			jQuery('#loader-wrapper').delay(350).fadeOut('slow'); // will fade out the white DIV that covers the website.
			jQuery('body').delay(350).css({'overflow':'visible'});
		})
	//]]>
function close_preloader () {
	jQuery('#loader-wrapper').delay(350).fadeOut('slow');
	jQuery('body').delay(350).css({'overflow':'visible'});
}
</script>
<?php } else { ?>
<style type="text/css" media="screen">
body{
	overflow: visible;
}	
</style>
<?php } ?>
</head>

<body <?php body_class(); ?>>
<?php 
	if(isset($xpanel['preloader']) && $xpanel['preloader'] == 1) {
?>
<div id="loader-wrapper">
    <div id="loader">
	</div>
	<div id="loader-message">
	<h2 class="text-center"><?php echo $xpanel['preloader-msg'] ?></h2> 
	</div>
	<a href="javascript:" onclick="close_preloader();" id="close-loader"><i class="fa fa-times-circle fa-3x"></i></a>
</div>
<?php } ?>
<div id="page" class="site container">
	<div class="site-inner">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'upaper' ); ?></a>

	<header id="masthead" class="site-header" role="banner">
		<div class="row small-header">
			<div class="header-socil-icons pl-10 col-lg-6 col-md-7 col-sm-8 col-xs-16">
				<ul>
					<li><a href="#" id="SearchO"><i class="fa fa-search"></i></a></li>
					<li><a href="<?php echo $xpanel['fb-url'] ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
					<li><a href="<?php echo $xpanel['twitter-url'] ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
					<li><a href="<?php echo $xpanel['gplus-url'] ?>" target="_blank"><i class="fa fa-google-plus"></i></a></li>
					<li><a href="<?php echo $xpanel['pinterest-url'] ?>" target="_blank"><i class="fa fa-pinterest"></i></a></li>
					<li><a href="<?php echo $xpanel['linkedin-url'] ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
					<li><a href="<?php echo $xpanel['reddit-url'] ?>" target="_blank"><i class="fa fa-reddit"></i></a></li>
					<li><a href="<?php echo $xpanel['stumble-url'] ?>" target="_blank"><i class="fa fa-stumbleupon"></i></a></li>
				</ul>
			</div>
			<div class="small-nav col-lg-10 col-md-9 co-sm-8 hidden-xs">
            	<?php wp_nav_menu( array( 'theme_location' => 'small', 'menu_id' => 'small-menu', 'container' => '', ) ); ?> 
            </div>
		</div>
		<!-- Logo & Banner -->
		<div class="header-content">
			<div class="logo col-lg-3 col-md-3 col-sm-16 col-xs-16 pr-0">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
					<img src="<?php echo $xpanel['logo']['url'] ?>">
				</a>
			</div><!-- // Logo -->
			<div class="header-banner col-lg-13 col-md-13 col-sm-16 col-xs-16 pl-0 text-left">
				<?php dynamic_sidebar('header-ad') ?>
			</div><!--// Header Banner -->
		</div><!-- // Logo & Banner -->

		<div class="row nav-row">
			<nav class="main-menu navbar navbar-default" id="main-nav">
		          <div class="navbar-header">
		            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
		              <span class="sr-only">Toggle navigation</span>
		              <span class="icon-bar"></span>
		              <span class="icon-bar"></span>
		              <span class="icon-bar"></span>
		            </button>
		          </div>
		          <div id="navbar" class="navbar-collapse collapse">
		          	<div class="nav-container">
		            <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu', 'container' => '', ) ); ?> 
		            </div>
		          </div><!--/.nav-collapse -->
		    </nav>
				
		</div><!--#Nav Wrap -->
		
	</header><!-- #masthead -->

<div id="content" class="site-content">
	<?php if($xpanel['show-news-ticker'] == TRUE) { ?>
	<div class="ticker-container">
		<div class="breaking_head hidden-xs">
			<span id="left-triangle" class="arrows animated infinite flash"></span> 
			<?php echo $xpanel['ticker-label'] ?>
		</div>
		<div class="newsTicker">
		<?php get_template_part( 'template-parts/news', 'ticker' ); ?>
		</div>
	</div>
	<?php } ?>
