<?php
/**
 * Javascript for Load More
 *
 */
function be_load_more_js() {
  
  if( ! is_singular( 'post' ) )
    return;
  $query = array( 
    'post__not_in' => array( get_queried_object_id() ), 
    'category_name' => ea_first_term( 'category', 'slug' ), 
    'posts_per_page' => 3 
  );
  $args = array(
    'nonce' => wp_create_nonce( 'be-load-more-nonce' ),
    'url'   => admin_url( 'admin-ajax.php' ),
    'query' => $query,
  );
  wp_enqueue_script( 'be-load-more', get_stylesheet_directory_uri() . '/js/load-more.js', array( 'jquery' ), '', true );
  wp_localize_script( 'be-load-more', 'beloadmore', $args );
	
}
add_action( 'wp_enqueue_scripts', 'be_load_more_js' );
/**
 * AJAX Load More 
 *
 */
function be_ajax_load_more() {
	check_ajax_referer( 'be-load-more-nonce', 'nonce' );
    
	$args = isset( $_POST['query'] ) ? array_map( 'esc_attr', $_POST['query'] ) : array();
	$args['post_type'] = isset( $args['post_type'] ) ? esc_attr( $args['post_type'] ) : 'post';
	$args['paged'] = esc_attr( $_POST['page'] );
	$args['post_status'] = 'publish';
	ob_start();
	$loop = new WP_Query( $args );
	if( $loop->have_posts() ): while( $loop->have_posts() ): $loop->the_post();
		be_post_summary();
	endwhile; endif; wp_reset_postdata();
	$data = ob_get_clean();
	wp_send_json_success( $data );
	wp_die();
}
add_action( 'wp_ajax_be_ajax_load_more', 'be_ajax_load_more' );
add_action( 'wp_ajax_nopriv_be_ajax_load_more', 'be_ajax_load_more' );
/**
 * First Term 
 * Helper Function
 */
function ea_first_term( $taxonomy, $field ) {
	$terms = get_the_terms( get_the_ID(), $taxonomy );
  
	if( empty( $terms ) || is_wp_error( $terms ) )
		return false;
	
	// If there's only one term, use that
	if( 1 == count( $terms ) ) {
		$term = array_shift( $terms );
	} else {
		$term = array_shift( $list );
	}
	
	// Output 	
	if( $field && isset( $term->$field ) )
		return $term->$field;
	
	else
		return $term;	
	
}