<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package UrduPaper
 */

get_header(); 
$ip_address = get_client_ip_server();

?>

	<div id="primary" class="content-area">
		<div class="single-sidebar pr-0 pl-0 col-lg-5 col-md-5 hidden-sm hidden-xs">
			<?php dynamic_sidebar('sidebar-single'); ?>
		</div>
		<div id="main" class="post-main pr-0 col-lg-11 col-md-11 col-sm-16 col-xs-16" role="main">
		<div class="above-post-ad">
			<?php 
				dynamic_sidebar('above-post-ad');
			?>
			</div>
			<?php
			while ( have_posts() ) : the_post();
				setViews(''.$ip_address.'',''.get_the_ID().'');
				get_template_part( 'template-parts/content', 'single' );

			endwhile; // End of the loop.
			?>
			<div class="below-post-ad">
			<?php 
				dynamic_sidebar('below-post-ad');
			?>
			</div>
			<?php 
				if ( isset( $xpanel['show-ratings'] ) && $xpanel['show-ratings'] == TRUE ) {
			?>
			<div class="post-ratings-block mb-10">
				<div class="post-ratings-header">
					<h2><?php echo _e("اس خبر پر اپنی رائے کا اظہار کریں") ?></h2>
				</div>
				<div class="post-ratings-container pt-10 mb-10">
					<?php 
						get_template_part( 'template-parts/posts', 'rating' );
					?>
				</div>
				<div id="rating-ajax-response"></div>
			</div>
			<?php } ?>
			
			<?php 
				if ( isset( $xpanel['show-related-posts'] ) && $xpanel['show-related-posts'] == TRUE ) {
			?>
			<div class="related-posts mb-10">
				<div class="related-posts-header">
					<h2><?php echo _e("مزید پڑھیں") ?></h2>
				</div>
				<div class="related-posts-container pt-10">
					<?php 
						$categories = get_the_category();
						$category_id = $categories[0]->cat_ID;
						$block_cat = $category_id;
						set_query_var( 'block_cat', $block_cat );
						get_template_part( 'template-parts/posts', 'related' );
					?>
				</div>
			</div>
			<?php } ?>

			<div class="comments-row">
			<?php 
				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;
			?>
			</div>
		</div><!-- #main -->
		<div class="single-sidebar pr-0 pl-0 hidden-lg hidden-md col-sm-16 col-xs-16">
			<?php dynamic_sidebar('sidebar-single'); ?>
		</div>
	</div><!-- #primary -->

<?php
get_footer();
