<?php
/**
 * Template part for displaying posts.
 *
 * @package UrduPaper
 */

?>

<div class="archive-post-grid col-lg-4 col-md-4 col-sm-8 col-xs-16">
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<div class="archive-post-thumbnail">
		<a href="<?php the_permalink() ?>" title="<?php the_title() ?>">
		<?php 
			if ( has_post_thumbnail() ) {
				the_post_thumbnail('postblock-grid');
			}
			else {
				echo '<img src="' . get_bloginfo( 'stylesheet_directory' ) . '/images/thumb-372x218.jpg" />';
			}
		?>
		</a>
		</div>
	</header><!-- .entry-header -->

	<div class="archive-entry-content">
		<h4>
			<a href="<?php the_permalink() ?>" title="<?php the_title() ?>">
				<?php
					the_title();
				?>
			</a>
		</h4>
	</div><!-- .entry-content -->

	<footer class="archive-footer pt-10">
		<div class="archive-post-meta">
			<?php get_template_part('template-parts/archive', 'meta') ?>
		</div><!-- .entry-meta -->
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
</div>
