<?php
/**
 * Template part for displaying a message that posts cannot be found.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package UrduPaper
 */

?>

<section class="no-results not-found">
	<header class="page-header">
		<h1 class="page-title text-center"><?php esc_html_e( 'معذرت چاہتے ہیں!', 'upaper' ); ?></h1>
	</header><!-- .page-header -->

	<div class="page-content page-content-404 text-center">
		<div class="text-404 pt-10 pb-10">
		<?php
		if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf( wp_kses( __( 'کیا آپ اپنی پہلی خبر شائعہ کرنے کے لیے تیار ہیں؟  <a href="%1$s">یہاں کلک کریں</a>.', 'upaper' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

		<?php elseif ( is_search() ) : ?>

			<p><?php esc_html_e( 'معذرت، آپ جو تلاش کرنا چاہ رہے ہیں اس کے متعلق ہمارے پاس کوئی ڈیٹا نہیں۔', 'upaper' ); ?></p>
			<?php
				get_search_form();

		else : ?>

			<p><?php esc_html_e( 'اس کیٹا گری میں کوئی خبر موجود نہیں۔ آپ دوسری کیٹاگری ملاحضہ فرمائیں', 'upaper' ); ?></p>
			<?php

		endif; ?>
		</div>
		<div class="icon-404 pt-10 pb-10 text-center">
			<i class="fa fa-exclamation-triangle"></i>
		</div>
	</div><!-- .page-content -->
</section><!-- .no-results -->
