<?php
/**
 * Template part for displaying posts.
 *
 * @package UrduPaper
 */
global $xpanel;
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		
		<div class="post-header-image">
			<?php the_post_thumbnail('post-head'); ?>
			<?php 
				if ( isset( $xpanel['show-views'] ) && $xpanel['show-views'] == TRUE ) {
			?>
			<span class="post-views-box"><i class="fa fa-eye pr-5"></i> <?php echo number_format(getViews(get_the_ID())) ?></span>
			<?php } ?>
		</div>
		<div class="post-sharing">
			<div class="sharing-label pull-right mb-5 hidden-xs">
				<h3><i class="fa fa-share fa-rotate-180"></i> شیئر کریں </h3>
			</div>
			<div class="sharing-icons pull-right">
				<?php get_template_part('template-parts/postheader', 'sharing') ?>
			</div>
		</div>
		<?php

			the_title( '<h1 class="entry-title">', '</h1>' );
		?>
		<div class="entry-meta">
			<?php get_template_part('template-parts/posts', 'meta') ?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->

	<div class="entry-content" id="post-conten-single">
		<?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'upaper' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'upaper' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php upaper_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
